<?php 

defined( 'UADMIN_DIR' ) OR DIE;

new class {

	protected $post;

	public function __construct() {
		
		$this->post = $_POST['ud-bulk'] ?? [];

		if( $_SERVER['REQUEST_METHOD'] !== 'POST' || empty($this->post) ) return;

		if( $this->secured() ) {
			$this->execPost();
		}

	}

	public function secured() {
		
		$secured = Uss::nonce( "tickets", $this->post['nonce'] ); 
		
		if( !$secured ) {
			Uss::console( '@alert', "<i class='bi bi-shield-exclamation me-1'></i> Security Check Failed" );
		};
		
		return $secured;
		
	}
	
	public function execPost() {
			
		$prefix = DB_TABLE_PREFIX;
		
		switch( $this->post['action'] ) {
			
			case 'delete':
					
					$values = implode(", ", array_map(function($value) {
						return Uss::$global['mysqli']->real_escape_string( $value );
					}, $this->post['values']));
					
					$SQL = "
						DELETE FROM {$prefix}_tickets
						WHERE id IN({$values});
					";
					
					$status = Uss::$global['mysqli']->query( $SQL );
					
					$message = $status ? "Ticket successfully deleted" : "Ticket(s) could not be deleted";
					
					Uss::console( '@alert', $message );
					
				break;
				
			default:
			
				events::exec('admin.support-ticket::POST');
			
		};

	}

};