<div class='container-fluid'>
    <div class='row'>
        <div class='col-lg-8 mx-auto'>
            <div class='card'>
                <div class='card-body'>

                    <div class='p-3 p-sm-5'>

                        <form method='POST'>
                            <fieldset>

                                <div class='mb-3'>
                                    <h5 class='text-capitalize mb-3'>I want to sell:</h5>
                                    <select name='paid_currency' class='form-select form-select-lg' required>
                                        <?php 
                                            foreach( $currencies as $key => $currency ):
                                                $balance = Bank::getUserBalance($user['id'], $currency['code']);
                                        ?>
                                        <option value='<?php echo $currency['code']; ?>' data-balance='<?php echo $balance; ?>'>
                                            <?php echo $currency['name'] . ' - ' . $currency['symbol'] . number_format($balance, 2); ?>
                                        </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class='mb-4'>
                                    <label class='form-label --required'>Amount</label>
                                    <input type='number' step='0.01' class='form-control form-control-lg' name='paid_amount' required placeholder='0.00'>
                                </div>

                                <div class='border-top my-4'></div>

                                <div class='mb-4'>
                                    <h5 class='mb-3 text-capitalize'>I want to buy:</h5>
                                    <select name='expected_currency' class='form-select form-select-lg' required>
                                        <?php
                                            foreach( $currencies as $key => $currency ):
                                        ?>
                                        <option value='<?php echo $currency['code']; ?>'>
                                            <?php echo $currency['name']; ?>
                                        </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <div class='alert alert-info fs-14px'>
                                    <i class='bi bi-info-circle'></i> 
                                    <?php echo Uss::console('exchange_fee'); ?>% Exchange Fee Applies
                                </div>

                                <div class='mb-4 input-group'>
                                    <span class='input-group-text' id='expected-unit'>USD</span>
                                    <input type='number' step='0.01' readonly name='expected_amount' class='form-control form-control-lg' value='0' id='to'>
                                </div>

                                <hr/>

                                <input type='hidden' name='usd_value'>
                                <input type='hidden' name='usd_fee'>

                                <button class='btn btn-primary btn-lg w-100'>
                                    Exchange Now
                                </button>

                            </fieldset>
                        </form>

                    </div>

                </div>
            </div>  
        </div>
    </div>
</div>