<div class='container-fluid'>
    
    <h3 class='mb-4'>Account statements</h3>

    <?php

        $bankNumber = Uss::$global['usermeta']->get('bank:number', Uss::$global['user']['id']);

        $SQL = "
            SELECT 
                %{prefix}_transfer_meta.*,
                %{prefix}_transfers.tx_date,
                %{CREDIT_SUMMATION} AS credits,
                %{DEBIT_SUMMATION} AS debits,
                (%{CREDIT_SUMMATION} - %{DEBIT_SUMMATION}) AS balance,
                DATE_FORMAT(%{prefix}_transfers.tx_date, '%Y-%M') AS monthly
            FROM 
                %{prefix}_transfer_meta
            INNER JOIN
                %{prefix}_transfers
            ON
                %{prefix}_transfers.tx_ref = %{prefix}_transfer_meta.tx_ref
            WHERE
                %{prefix}_transfer_meta.account_number = '%{bank_number}'
            GROUP BY
                DATE_FORMAT(%{prefix}_transfers.tx_date, '%Y-%M')
        ";

        $__sum = function( string $type ) {

            $query = "SUM(
                CASE 
                    WHEN %{prefix}_transfer_meta.tx_type = '%{type}' 
                    THEN %{prefix}_transfer_meta.amount
                    ELSE 0
                END
            )";

            $query = Core::replace_var( $query, [
                "prefix" => DB_TABLE_PREFIX,
                "type" => $type
            ]);

            return $query;

        };

        $SQL = Core::replace_var( $SQL, [
            "bank_number" => $bankNumber,
            "prefix" => DB_TABLE_PREFIX,
            "CREDIT_SUMMATION" => $__sum('credit'),
            "DEBIT_SUMMATION" => $__sum('debit')
        ]);

        $result = Uss::$global['mysqli']->query( $SQL );

        # Generate Statement

        $tablet = new DOMTablet( 'statement' );

        $tablet->data( $result );

        $tablet->columns([
            'monthly' => 'month',
            'credits',
            'debits',
            'balance' => "Recurring",
            'view' => ''
        ]);

        $tablet->wrap();

        $tablet->prepare(function($data) {
            
            $preview = [
                'credits' => 'success', 
                'debits' => 'danger', 
                'balance' => 'primary'
            ];

            foreach($preview as $key => $color) {

                $conversion = (new Converter( Uss::$global['user']['id'], 'to' ))
                    ->amount( $data[$key] )
                    ->from( 'USD' )
                    ->convert();

                $data[$key] = 
                    $conversion->symbol . 
                    "<span class='text-{$color}'>" . number_format($conversion->amount, 2) . "</span>";
            };

            $href = Core::url( ROOT_DIR . "/" . implode("/", Uss::query()) . "/{$data['monthly']}" );

            $data['view'] = "
                <a href='{$href}' class='btn btn-sm btn-outline-primary' target='_blank'>
                    <i class='bi bi-arrow-up-right'></i> View
                </a>
            ";

            return $data;

        }, true);

    ?>

</div>      