<?php

$credentialRoute = UADMIN_ROUTE . '/users/manage-users';

$userHref = $userMenu->get('list')->getAttr('href');

$credentialMenu = $userMenu->add('credential', [
    'label' => "Manage Users",
    "href" => Core::url( ROOT_DIR . "/{$credentialRoute}" )
]);

Uss::route( $credentialRoute, function() use($credentialMenu) {

    $credentialMenu->setAttr('active', true);
    $credentialMenu->parentMenu->setAttr('active', true);

    Udash::view(function() {

        $SQL = SQuery::select( DB_TABLE_PREFIX . "_users", "1 ORDER BY id DESC" );

        $result = Uss::$global['mysqli']->query( $SQL );

        $tablet = new DOMTablet( 'tablet' );

        $tablet->data( $result );
        
        $tablet->wrap();

        $tablet->columns([
            'email',
            'bank_number' => 'Account Number',
            'usercode',
            'edit'
        ]);

        $tablet->prepare(function($data) {
            $href = Core::url( ROOT_DIR . "/" . implode("/", array_slice(Uss::query(), 0, -1)) );
            $href .= "/@credential/{$data['usercode']}";
            $data['edit'] = "
                <a href='{$href}' class='btn btn-outline-primary'>
                    <i class='bi bi-pen'></i>
                </a>
            ";
            $data['bank_number'] = Uss::$global['usermeta']->get('bank:number', $data['id']);
            return $data;
        }, true);

    });

});