<?php

$transfer = new class {

    public $codes;

    public function __construct() {

        $this->codes = Uss::$global['options']->get('bank:transfer.codes');

        $this->editor();
        $this->deletion();

        if( $_SERVER['REQUEST_METHOD'] != 'POST' ) return;
        
        $this->processCode();

    }

    protected function editor() {

        $edit = $_GET['edit'] ?? null;
        if( is_null($edit) || !is_numeric($edit) ) return;

        $code =  $this->codes[$edit] ?? null;
        if( !$code ) return;

        $key = array_keys($code)[0];
        $value = $code[$key];

        Uss::tag('code-title', strtoupper($key));
        Uss::tag('code-value', $value);
        Uss::tag('code-id', $edit);

        Uss::tag('action', 'Update Code');

        Uss::tag('cancel-text', "<i class='bi bi-x'></i> Cancel Update");

    }

    protected function deletion() {
        if(isset($_GET['remove']) && is_numeric($_GET['remove'])) {
            $index = (int)$_GET['remove']; 
            if(isset($this->codes[$index])) {
                unset($this->codes[$index]);
                Uss::$global['options']->set('bank:transfer.codes', $this->codes);
            };
        }
    }

    protected function processCode() {

        $key = strtolower($_POST['code']);
        $value = $_POST['value'];
        $codeID = trim($_POST['id']);

        if( empty($value) ) $value = null;
        
        # Add New Code 

        if( $codeID == '' ) {

            if( !empty(array_column($this->codes, $key)) ) {

                return Bank::log('info', 'The transfer code has already been added' );

            } else {

                $this->codes[] = [$key => $value];

                $reaction = "added";

            }

        } else {

            $this->codes[ $codeID ] = [$key => $value];

            $reaction = "updated";

        };

         $status = Uss::$global['options']->set('bank:transfer.codes', $this->codes );

        if( $status ) {
            Bank::log('success', "Transfer code successfully {$reaction}");
        } else {
            Bank::log('error', "The transfer code could not be {$reaction}");
        };
        
    }

    public function printTable() {

        $tablet = new DOMTablet('transfer-code');

        $tablet->columns([
            'title' => "code title",
            'type',
            'code',
            'action' => ''
        ]);

        $data = array();

        foreach( $this->codes as $index => $codeset ) {
            foreach( $codeset as $key => $value ) {
                $data[] = [
                    'title' => strtoupper($key),
                    'type' => is_null($value) ? 'auto' : 'manual',
                    'code' => $value,
                    'index' => $index
                ];
            };
        }

        $tablet->data( $data );

        $tablet->wrap();

        $tablet->prepare(function($data) {
            if( empty($data['code']) ) $data['code'] = "<i class='bi bi-question-circle'></i>";
            $data['action'] = "
                <a href='?edit={$data['index']}' class='btn btn-outline-primary'>
                    <i class='bi bi-pencil'></i>
                </a>
                <a href='?remove={$data['index']}' data-uss-confirm='Please confirm the process' class='btn btn-danger'>
                    <i class='bi bi-trash'></i>
                </a>
            ";
            return $data;
        }, true);

    }

};